import { Link, useLocation } from 'react-router-dom'
import { Apple, Calendar } from 'lucide-react'
import Footer from './Footer'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <div className="layout-wellness">
      <header className="header-wellness">
        <div className="container">
          <div className="header-content-wellness">
            <Link to="/" className="logo-wellness">
              <div className="logo-icon-wellness">
                <Apple size={28} />
              </div>
              <div className="logo-text-wellness">
                <span className="logo-title-wellness">NutriWell</span>
                <span className="logo-subtitle-wellness">Wellness консультации</span>
              </div>
            </Link>
            <nav className="nav-wellness">
              <Link 
                to="/" 
                className={`nav-link-wellness ${location.pathname === '/' ? 'active' : ''}`}
              >
                Мои консультации
              </Link>
              <Link 
                to="/enroll" 
                className={`nav-link-wellness ${location.pathname === '/enroll' ? 'active' : ''}`}
              >
                Записаться
              </Link>
            </nav>
          </div>
        </div>
      </header>
      <main className="main-wellness">
        {children}
      </main>
      <Footer />
    </div>
  )
}

export default Layout
